import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { filterProductData } from "../../../screens/Home/FeatureDIsplay/filterProductData.js";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    featureProducts: [],
    loading: false,
    nextPageUrl: "",
    loadMore: false,
};

export const getFeatureProducts = createAsyncThunk(
    "items/getFeatureProducts",
    async (URL) => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);
export const getMoreFeatureProducts = createAsyncThunk(
    "items/getMoreFeatureProducts",
    async (URL) => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);

const featureProductsSlice = createSlice({
    name: "items",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getFeatureProducts.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getFeatureProducts.fulfilled, (state, { payload }) => {
            const { data = [], pagination: { next_page_url } = {} } =
                payload?.records || {};
            const { code } = payload?.status || {};
            if (code == 200) {
                let newData = filterProductData(data);
                state.featureProducts = newData;
                state.nextPageUrl = next_page_url;
            } else {
                state.featureProducts = state.featureProducts;
            }
            state.loading = false;
        });
        builder.addCase(getFeatureProducts.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreFeatureProducts.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(
            getMoreFeatureProducts.fulfilled,
            (state, { payload }) => {
                const { data = [], pagination: { next_page_url } = {} } =
                    payload?.records || {};
                const { code } = payload?.status || {};
                if (code == 200) {
                    let newData = filterProductData(data);
                    state.featureProducts = [
                        ...state.featureProducts,
                        ...newData,
                    ];
                    state.nextPageUrl = next_page_url;
                } else {
                    state.featureProducts = state.featureProducts;
                }
                state.loadMore = false;
            }
        );
        builder.addCase(getMoreFeatureProducts.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export default featureProductsSlice.reducer;
